# Define Percent Complete (example of how to add a new Column Type)
# 040702 - first draft of program
# 040713 - release script with new name
# 060211 - Alex - use the helper functions in Data.py

# Will add a new column type that can be inserted into reports.
# Must be run against each file to include new column option.

# The following will add a new Column Type named "PercentComplete"
#    that can be used in Task reports.

# If you want to make sure the column types you add don't conflict
#    with new releases of GanttPV, prefix the Name with "xx". For
#    example: "xxTaskOwner", etc.
#    (In this case it isn't necessary because "PercentComplete" is the 
#    name that will be used in future releases.)

def DoAdd():
    rt = { 'Name': 'Task' }  
    ct = [
    { 'Name': 'PercentComplete', 'Label': 'Percent\nComplete', 'DataType': 'i', 'AccessType': 'd', 'T': 'A', 'Edit': True,  'Width': 80  },
        ]
    Data.AddReportType(rt, ct)
    Data.SetUndo("Install Percent Complete")

DoAdd()